## R![]()aspberry Pi + LabVIEW实现网络摄像机



8月的挑战项目是RaspberryPi + LabVIEW实现网络摄像机。树莓派小巧廉价，初学者上手的难度也不大，再加上LabVIEW的视觉开发模块非常的强大实用，花费几个小时的学习，你就能把你的树莓派和家用usb摄像头组装成一个网络摄像机~~好了，废话不多说，开始展示一下制作过程吧！

 

社区寄来的包裹里面，有以下的物品：

*  树莓派2一块
* USB摄像头一枚
* MicroSD卡一块
* USB无线网卡

另外，如果需要进行网络摄像机的制作，最好需要准备下面的物品：

* 一台可以供树莓派连接的显示器

（最后为了能够固定和保护摄像头和树莓派，最好能准备一个摄像头防护罩

有了以上准备，我们就可以开始了

### Step1:树莓派安装MJPG-Streamer

MJPG-Streamer可以将摄像头采集的图像传送到本地ip的端口，在同一个网络下的其他终端可以通过浏览器浏览采集的图像流。于是，第一步先在树莓派上安装MJPG-Streamer

打开Terminal

先安装依赖库：

```
sudo apt-get install libjpeg8-dev  
```

需要用到cmake

```
sudo apt-get install cmake  
```

若不成功，更新一下apt列表

```
sudo apt-get update  
sudo apt-get upgrade
```

开启摄像头

```
sudo raspi-config
```

选择Enable Camera

重启后，从GitHub上下载zip文件

[https://github.com/jacksonliam/mjpg-streamer](https://github.com/jacksonliam/mjpg-streamer)

解压

```
unzip mjpg-streamer-master.zip  
```

进入目录中

```
cd mjpg-streamer-master/
cd mjpg-streamer-experimental/
```

进行编译

```
make clean all
```

 启动摄像头

```
 ./mjpg_streamer -i "./input_uvc.so" -o "./output_http.so -w ./www"
```



保持PC和树莓派连接在同一个Wifi中。（若是没有路由器，用PC开设无线热点也可）

这个时候，在浏览器中输入链接：

```
http://<树莓派IP>:8080/?action=stream
```

就可以看到摄像头截取的图像了。

![通过浏览器看到摄像头图像](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h17m13s_005_.png)

### Step2:将网络摄像头转成本地摄像头

通过IP Camera Adapter将网络摄像头转成本地摄像头

![IP Camera Adapter](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h18m50s_006_.png)

设置界面如下：

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h20m50s_007_.png)

将url拷贝进第一栏，username填pi(默认密码是raspberry)也可填root，密码自己设定

此时，可以理解为树莓派的摄像头成为了我们本地的摄像头，可以把树莓派随意拿到较远的地方。



### Step3：安装LabVIEW和VAS

具体的安装过程就不说了。安装文件可以在官网上下载，或者用社区提供的链接。

### Step4：在LabVIEW上查看USB摄像头图像

LabVIEW是一个强大的工具，并且具有图形化的界面，同时拥有了基本的逻辑结构，通过图形化的连接，你就可以开发强大、复杂的功能。

首先，点击LabVIEW的tools->Measurement & Automation Exploer

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h30m11s_008_.png)

然后在打开的面板中选中MJPEG Camera，记住你的Camera编号

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h32m48s_009_.png)

点击Grab，就是获取视频流，可以看到，获取的是USB摄像头上的图像。

### Step5: 写一个VI，实现摄像头的实时监控和图像捕捉

打开LabVIEW,在面板中点击Create Project，创建一个Blank VI ,然后进行编辑

LabVIEW的前面板的Control栏，在安装了VAS之后，会多出

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h38m41s_011_.png)

后面板Function会多出

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h38m15s_010_.png)



通过这里面的模块，我们可以实现摄像头的实时监控

这里附上我的VI文件

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h43m30s_012_.png)

简单解释一下：

主循环是一个while循环，跳出循环通过点击Stop Button实现。

主循环中有一个case structure，在保存图像的Button按键按下后，Case为True，执行保存图像功能，保存的命名方式为时-分-秒.png，LabVIEW的IMAQ Write File2 还提供了其他几种图像格式，可以自己更改。

运行一下。

这是实验室的工具柜，USB摄像头的分辨率较低诶

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h51m19s_013_.png)

点击保存图像，可以看到保存路径内

![](C:\Users\yuze\Pictures\Ashampoo Snap 8\Ashampoo_Snap_2016.08.03_19h54m00s_014_.png)

OK,整个工程大功告成！

最后附上树莓派的图片，和装上保护壳后的样子。

![](C:\Users\yuze\Documents\Tencent Files\752874789\FileRecv\MobileFile\IMG_1886.JPG)

设置的过程中，用到了HDMI接显示屏，键盘、鼠标和摄像头

![](C:\Users\yuze\Documents\Tencent Files\752874789\FileRecv\MobileFile\IMG_1892.JPG)

整个摄像机只需要摄像头和树莓派，还有无线网卡就可以了

保护壳装上后。

![](C:\Users\yuze\Documents\Tencent Files\752874789\FileRecv\MobileFile\IMG_1891.JPG)

背面

![](C:\Users\yuze\Documents\Tencent Files\752874789\FileRecv\MobileFile\IMG_1890.JPG)





